//
//  PersistenceViewController.m
//  Persistence
//
//  Created by Robert Górczyński on 11-07-15.
//

#import "PersistenceViewController.h"
#import "FourLines.h" 

@implementation PersistenceViewController
@synthesize field1; 
@synthesize field2; 
@synthesize field3; 
@synthesize field4; 

- (NSString *)dataFilePath { 
    NSArray *paths = NSSearchPathForDirectoriesInDomains( 
														 NSDocumentDirectory, NSUserDomainMask, YES); 
    NSString *documentsDirectory = [paths objectAtIndex:0]; 
    return [documentsDirectory stringByAppendingPathComponent:kFilename]; 
} 

#pragma mark - 
- (void)viewDidLoad { 
    NSString *filePath = [self dataFilePath]; 
    if ([[NSFileManager defaultManager] fileExistsAtPath:filePath]) { 
        NSArray *array = [[NSArray alloc] initWithContentsOfFile:filePath]; 
        field1.text = [array objectAtIndex:0];
        field2.text = [array objectAtIndex:1]; 
        field3.text = [array objectAtIndex:2]; 
        field4.text = [array objectAtIndex:3]; 
        [array release];
		
        NSData *data = [[NSMutableData alloc] 
						initWithContentsOfFile:[self dataFilePath]]; 
        NSKeyedUnarchiver *unarchiver = [[NSKeyedUnarchiver alloc] 
										 initForReadingWithData:data]; 
        FourLines *fourLines = [unarchiver decodeObjectForKey:kDataKey]; 
        [unarchiver finishDecoding]; 
		
        field1.text = fourLines.field1; 
        field2.text = fourLines.field2; 
        field3.text = fourLines.field3; 
        field4.text = fourLines.field4; 
		
        [unarchiver release]; 
        [data release]; 		
    } 
	
    UIApplication *app = [UIApplication sharedApplication]; 
    [[NSNotificationCenter defaultCenter] addObserver:self 
											 selector:@selector(applicationWillResignActive:) 
												 name:UIApplicationWillResignActiveNotification 
											   object:app]; 
    [super viewDidLoad]; 
} 
- (void)applicationWillResignActive:(NSNotification *)notification { 
    NSMutableArray *array = [[NSMutableArray alloc] init]; 
    [array addObject:field1.text]; 
    [array addObject:field2.text]; 
    [array addObject:field3.text]; 
    [array addObject:field4.text]; 
    [array writeToFile:[self dataFilePath] atomically:YES]; 
    [array release]; 

    FourLines *fourLines = [[FourLines alloc] init]; 
    fourLines.field1 = field1.text; 
    fourLines.field2 = field2.text; 
    fourLines.field3 = field3.text; 
    fourLines.field4 = field4.text; 
	
    NSMutableData *data = [[NSMutableData alloc] init]; 
    NSKeyedArchiver *archiver = [[NSKeyedArchiver alloc] 
								 initForWritingWithMutableData:data]; 
    [archiver encodeObject:fourLines forKey:kDataKey]; 
    [archiver finishEncoding]; 
    [data writeToFile:[self dataFilePath] atomically:YES]; 
    [fourLines release]; 
    [archiver release]; 
    [data release]; 	
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.field1 = nil; 
    self.field2 = nil; 
    self.field3 = nil; 
    self.field4 = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
	[field1 release]; 
    [field2 release]; 
    [field3 release]; 
    [field4 release]; 	
    [super dealloc];
}

@end
